(*| 22:32  3/05/1995 *)
PROGRAM VIDEOSET;

USES Dos,Crt,StdTypes,KeyBoard;

CONST
  MaxLine   = 16;
  RegNameLen= 24;
  MaxCgaReg = 16;
  MaxCrtReg = 25;
  MaxTriCrtReg = 32;
  MaxParReg = 16;
  MaxTriSeqReg = 16;
  MaxGcrReg = 9;
  MaxSeqReg = 5;
  MaxCmosReg= 32;
  MaxAttrReg= 20;
  MaxDosReg = 5;

  VParamSize= 64;
  DosOfs    = 0;
  SeqOfs    = 5-1;
  MiscOfs   = 9;
  CrtOfs    = 10;
  AttrOfs   = 35;
  GcrOfs    = 55;

TYPE
  RegNameType   = STRING[RegNameLen];
  AdaptorType   = (MDA,CGA,EGA,VGA);
  RegType       = (CrtReg,GcrReg,SeqReg,MiscReg,CgaReg,Cmos,AttrReg,DosReg);
  VideoParamType= ARRAY[0..VParamSize-1] OF Byte;

CONST
  SeqRegNames : ARRAY[1..MaxTriSeqReg] OF RegNameType =
     ('Reset','Clocking Mode','Write Plane Mask','Char Font Select',
      'Memory Mode','','','','','','','Hardware Version','','Trident',
      'Power-up Mode 1','Power-up Mode 2');
  GcrRegNames : ARRAY[1..MaxParReg] OF RegNameType =
     ('Data Set/Reset','Enable Bit Set/Reset','Colour Compare',
      'Data Rotate','Read Plane Select','Mode','Miscellaneous',
      'Colour Dont Care','Bit Mask'
      ,'PROA Address Offset A','PROB Address Offset B','PR1 Memory Size'
      ,'PR2 Video Select','PR3 CRT Control'
      ,'PR4 Video Control','PR5 Lock/Status'
      );
  CrtRegNames : ARRAY[1..MaxTriCrtReg] OF RegNameType =
     ('Horiz total','Horiz display','Horiz Blank start','Horiz Blank end',
      'Horiz Retrace start','Horiz Retrace end','Vert total +o0','Overflow',
      'Preset Row Scan','Max Scan Line','Cursor start','Cursor end',
      'Start high','Start low','Cursor high','Cursor low',
      'Vert Retrace start +o2','Vert Retrace end','Vert display +o1','Offset',
      'Underline','Vert Blank start +o3','Vert Blank end','Mode Control',
      'Line Compare +o4','','','','','','Trident','Trident');
  CgaRegNames : ARRAY[1..MaxCgaReg] OF RegNameType =
     ('Horiz total','Horiz display','Horiz Sync Pos','Horiz Sync Width',
      'Vert total','Vert Tot Adj','Vert display','Vert Sync Pos',
      'Interlace Mode','Max Scan Line','Cursor start','Cursor end',
      'Start high','Start low','Cursor high','Cursor low');
  Cmos1RegNames : ARRAY[1..MaxCmosReg] OF RegNameType =
     ('Secs','','Mins','','Hours','','Day Num','Day','Month','Year',
      'Status A','Status B','Status C','Status D','Diag Status','Reset Code',
      'Floppy','','Hard #1#2','','Equip','Base Mem k','  msb',
      'Ext Mem k','  msb','Hard #1','Hard #2','','','','','');
  Cmos2RegNames : ARRAY[1..MaxCmosReg] OF RegNameType =
     ('','','','','','','','','','',
      '','','','','Checksum','  lsb',
      'Ext Mem',' msb','Century','','','','',
      '','','','','','','','Checksum 2','  lsb');
  CgaRegDefaults : ARRAY[1..MaxCgaReg] OF Byte =
       ($71,$50,$5A,$0A,$1F,$06,$19,$1C,$02,$07,$06,$07,$00,$00,$00,$00);
  CgaMiscDefault = $29;
  AttrRegNames : ARRAY[1..MaxAttrReg] OF RegNameType =
     ('','','','','','','','','','','','','','','','',
      'Mode','Overscan','Colour Plane Enable','Horiz Panning');
  DosRegNames : ARRAY[1..MaxDosReg] OF RegNameType =
     ('Cols','Lines','Bytes/Char','Regen LSB','Regen MSB');

VAR
  Key         : Char;
  KeyFunc     : KeyType;
  Done        : Boolean;
  Base        : Integer;
  Count       : Integer;
  Index       : Integer;
  BitPtr      : Integer;
  ThisReg     : Byte;
  RegOfs      : Integer;
  RegClass    : RegType;
  CmosBlock   : Integer;
  Adaptor     : AdaptorType;
  Crt_Mode    : Byte ABSOLUTE $40:$49;
  Crt_Cols    : Byte ABSOLUTE $40:$4A;
  Crt_RegenLSB: Byte ABSOLUTE $40:$4C;
  Crt_RegenMSB: Byte ABSOLUTE $40:$4D;
  Crt_Base    : Word ABSOLUTE $40:$63;
  Cga_Mode    : Byte ABSOLUTE $40:$65;
  Crt_Lines   : Byte ABSOLUTE $40:$84;
  Crt_Points  : Byte ABSOLUTE $40:$85;
  V_Save_Ptr  :^Pointer ABSOLUTE $40:$A8;
  ParamRegs   : VideoParamType;
  EgaVga      : Boolean;
  ParadiseVga : Boolean;
  TridentVga  : Boolean;
  ParamStr1   : String;
  ForceMode   : Integer;

PROCEDURE WaitKey(VAR Key: Char; VAR KeyFunc: KeyType);
BEGIN
  REPEAT
  UNTIL KeyReady;
  GetKey(Key,KeyFunc);
END;  { WaitKey }

PROCEDURE WriteHex(N,Size: Integer);

Var
  I,J,K,Mask: Integer;

BEGIN
  J:=(Size-1)*4;
  Mask:=15 SHL J;
  FOR I:=1 TO Size DO
    BEGIN
      K:=(N AND Mask) SHR J;
      IF K > 9 THEN Write(Chr(K+55)) ELSE Write(K);
      Mask:=Mask SHR 4;
      J:=J-4;
    END;
  Write('H ');
END;  { WriteHex }

(*
PROCEDURE ShowPtr(ThisPtr: Pointer);
BEGIN
  WriteHex(Seg(ThisPtr^),4);
  Write(':');
  WriteHex(Ofs(ThisPtr^),4);
  Writeln;
END;  { ShowPtr }
*)

PROCEDURE ShowParams(Mode:Integer; Base:Pointer; BiosParams: Boolean);
VAR
  VideoParams :^VideoParamType;

PROCEDURE ShowHexParams(First,Last: Integer);
VAR
  I: Integer;
BEGIN
  Write(' ':4);
  FOR I:=First TO Last DO BEGIN
    WriteHex(VideoParams^[I],2);
  END;
  Writeln;
END;

FUNCTION Over(Mask:Byte):Integer;
BEGIN
  IF (VideoParams^[CrtOfs+7] AND Mask) > 0 THEN
    Over:=256
  ELSE
    Over:=0;
END;

PROCEDURE ShowCrtParams;
VAR
  TextMode,Dot9,DoubleRow,DoubleCol: Boolean;
  HChars,VChars,HPixels,VPixels,CharPixels: Integer;
BEGIN
  HChars:=VideoParams^[CrtOfs+1]+1;
  VPixels:=VideoParams^[CrtOfs+$12]+1+Over(2) + (Over($40) SHL 1);
  IF TRUE THEN BEGIN
    TextMode:= (VideoParams^[GcrOfs+6] AND 1) = 0;
    Dot9:= (VideoParams^[SeqOfs+1] AND 1) = 0;
    DoubleCol:= (VideoParams^[SeqOfs+1] AND $8) > 0;
    DoubleRow:= (VideoParams^[CrtOfs+9] AND $80) > 0;
    CharPixels:=(VideoParams^[CrtOfs+9] AND $1F) + 1;
    IF TextMode THEN
      Write('TEXT')
    ELSE
      Write('GRAPHICS');
    IF Dot9 THEN
      HPixels:=HChars * 9
    ELSE
      HPixels:=HChars * 8;
    IF DoubleCol THEN
      HPixels:=HPixels * 2;
    VChars:= VPixels DIV CharPixels;
    IF DoubleRow THEN
      VChars:=VChars DIV 2;
    Write(' ',HChars,'x',VChars,', ',HPixels,'x',VPixels);
    IF (VideoParams^[GcrOfs+5] AND $40) <> 0 THEN
      Write(' 256 colour')
    ELSE CASE (VideoParams^[GcrOfs+6] AND $0C) OF
      $00: Write(' 128K');
      $04: Write(' 64K');
      $08: Write(' MONO');
      $0C: Write(' 32K');
    END;
  END ELSE BEGIN
    Write('H Disp ',HChars);
    Write(' H Tot ',VideoParams^[CrtOfs+0]+1);
    Write(' V Disp ',VPixels);
    Write(' V Tot ',VideoParams^[CrtOfs+6]+Over(1));
    Write(' V Blank ',VideoParams^[CrtOfs+$15]+1+Over(8));
    Write(' V Blank ',VideoParams^[CrtOfs+$16]+1);
  END;
  Writeln;
END;

BEGIN
  IF BiosParams THEN
    VideoParams:=Ptr(Seg(Base^),Ofs(Base^)+(Mode*$40))
  ELSE
    VideoParams:=Addr(ParamRegs);
  Write('Dos':4);
  ShowHexParams(0,SeqOfs);
  Write('Seq':4);
  ShowHexParams(SeqOfs+1,MiscOfs);
  Write('CRT':4);
  ShowHexParams(CrtOfs,CrtOfs+15);
  Write('    ');
  ShowHexParams(CrtOfs+16,AttrOfs-1);
  Write('Att':4);
  ShowHexParams(AttrOfs,AttrOfs+15);
  Write('    ');
  ShowHexParams(AttrOfs+16,GcrOfs-1);
  Write('GCR':4);
  ShowHexParams(GcrOfs,VParamSize-1);
  IF BiosParams THEN
    Write('Mode ',Mode,' : ')
  ELSE
    Write('Current : ');
  Write(VideoParams^[0],' Cols, ',VideoParams^[1]+1,
                ' Rows, ',VideoParams^[2],' Pixels,   ');
  ShowCrtParams
END;  { ShowParams }

PROCEDURE ShowAdaptorName;
BEGIN
  CASE Adaptor OF
    MDA:Write('MDA');
    CGA:Write('CGA');
    EGA:Write('EGA');
    VGA:Write('VGA');
  END;
END;  { ShowAdaptorName }

FUNCTION IsEga: Boolean;
VAR
  Regs:Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$1200;
    BL:=$10;
    INTR($10,Regs);
    IsEga := (BL <> $10);
  END;
END;  { IsEga }

FUNCTION IsVga: Boolean;
VAR
  Regs:Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$1A00;
    INTR($10,Regs);
    IsVga := (AL = $1A);
  END;
END;  { IsVga }

FUNCTION IsParadise: Boolean;
TYPE
  IdentType = ARRAY[1..4] OF Char;
VAR
  Regs:Registers;
  Ident1: IdentType ABSOLUTE $C000:$007D;
  Ident2: IdentType;
  Result: Boolean;
BEGIN
  Ident2:='VGA=';
  Result := (Ident1 = Ident2);
  IF Result THEN WITH Regs DO BEGIN
    AX:=$007F;
    BH:=$02;
    INTR($10,Regs);
    Result := (BH = $7F);
  END;
  IsParadise:=Result;
END;

FUNCTION IsTrident: Boolean;
VAR
  Result : Boolean;
  OldCrtMode,OldState,NewState: Byte;
  Regs: Registers;
BEGIN
  Port[$3C4] := $0B;
  Result := ((Port[$3C5] AND $0F)=$03);
  OldCrtMode := Crt_Mode;
  IF Result AND (OldCrtMode <= 3) THEN BEGIN
    Port[$3C4] := $0E;
    OldState := Port[$3C5];
    Port[$3C5] := OldState;
    NewState := Port[$3c5];
    WITH Regs DO BEGIN
      AX := OldCrtMode;
      INTR($10,Regs);
    END;
    Result := ((NewState XOR OldState) = $02);
  END;
  IsTrident:=Result;
END;

PROCEDURE SetParamRegs;
VAR
  I:Integer;
  Base:Pointer;
  VideoParams :^VideoParamType;
BEGIN
  IF EgaVga THEN BEGIN
    Base:=V_Save_Ptr^;
    IF ForceMode > 0 THEN
      VideoParams:=Ptr(Seg(Base^),Ofs(Base^)+(ForceMode*$40))
    ELSE IF Adaptor = EGA THEN
      VideoParams:=Ptr(Seg(Base^),Ofs(Base^)+((Crt_Mode+19)*$40))
    ELSE
      VideoParams:=Ptr(Seg(Base^),Ofs(Base^)+(24*$40));
    ParamRegs:=VideoParams^;
  END ELSE BEGIN
(*  ParamRegs[MiscOfs]:=CgaMiscDefault;*)
    ParamRegs[MiscOfs]:=Cga_Mode;
    FOR I:=1 TO MaxCgaReg DO
      ParamRegs[I+CrtOfs-1]:=CgaRegDefaults[I];
  END;
END;  { SetParamRegs }

PROCEDURE SetAdaptor;
VAR
  I:Integer;
BEGIN
  EgaVga:=False;
  IF Crt_Mode=7 THEN
    Adaptor:=MDA
  ELSE IF Crt_Mode < 4 THEN BEGIN
    Adaptor:=CGA;
    IF IsEga THEN BEGIN
      Adaptor:=EGA;
      EgaVga:=True;
      IF NOT IsVga THEN
      ELSE BEGIN
        Adaptor:=VGA;
        TridentVga:=False;
        ParadiseVga:=IsParadise;
        IF NOT ParadiseVga THEN
          TridentVga:=IsTrident;
      END;
    END;
  END ELSE BEGIN
    Writeln('Invalid video mode - ',Crt_Mode);
    HALT;
  END;
  ForceMode := 0;
  SetParamRegs;
  TextColor(Yellow);
  TextBackground(Blue);
END;  { SetAdaptor }

PROCEDURE ResetAdaptor;
BEGIN
  TextMode(Crt_Mode);
  SetAdaptor;
END;  { ResetAdaptor }

PROCEDURE GetThisReg;
VAR
  B: Byte;
BEGIN
  IF RegClass = AttrReg THEN
    B := Port[$3DA];                    {reset index/data flip-flop}
  IF RegClass = MiscReg THEN
    IF Adaptor <> VGA THEN
      ThisReg:=ParamRegs[MiscOfs]
    ELSE BEGIN
      ThisReg:=Port[$3CC];
      ParamRegs[MiscOfs] :=ThisReg;
    END
  ELSE BEGIN
    IF RegClass = DosReg THEN
      ThisReg:=ParamRegs[Index-1+RegOfs]
    ELSE IF (Adaptor <> VGA) AND (RegClass <> Cmos) THEN
      ThisReg:=ParamRegs[Index-1+RegOfs]
    ELSE BEGIN
      IF RegClass=Cmos THEN
        Port[Base]:=Index+(MaxCmosReg*CmosBlock)-1
      ELSE
        Port[Base]:=Index-1;
      ThisReg:=Port[base+1];
      IF NOT ((RegClass = GcrReg) AND (Index > MaxGcrReg)) THEN
        ParamRegs[Index-1+RegOfs]:=ThisReg;
    END;
  END;
  IF RegClass = AttrReg THEN BEGIN
    B := Port[$3DA];                    {reset index/data flip-flop}
    Port[$3C0] := $20;                  {re-enable attr access}
  END;
END;  { GetThisReg }

PROCEDURE SetVgaParams;

  PROCEDURE SetTheseRegs(ThisRegClass:RegType;
                         ThisRegOfs,ThisBase,Start,Count: Integer);
  BEGIN
    Base := ThisBase;
    RegOfs := ThisRegOfs;
    RegClass := ThisRegClass;
    FOR Index := Start TO Count DO
      GetThisReg;
  END;

BEGIN
  SetTheseRegs(MiscReg,MiscOfs,$3D8,1,1);
  SetTheseRegs(CrtReg,CrtOfs,$3D4,1,MaxCrtReg);
  SetTheseRegs(GcrReg,GcrOfs,$3CE,1,MaxGcrReg);
  SetTheseRegs(SeqReg,SeqOfs,$3C4,2,MaxSeqReg);
  SetTheseRegs(AttrReg,AttrOfs,$3C0,1,MaxAttrReg);
END;  { SetVgaParams }

PROCEDURE SplitGotoXY(X:Integer);
BEGIN
  IF Index > MaxLine THEN
    GotoXY(X+40,Index+2-MaxLine)
  ELSE
    GotoXY(X,Index+2);
END;  { SplitGotoXY }

PROCEDURE EraseIndex;
BEGIN
  SplitGotoXY(1);
  Write(' ');
  GotoXY(1,1)
END;  { ShowIndex }

PROCEDURE ShowRegName;
BEGIN
  CASE RegClass OF
    CrtReg : Write(CrtRegNames[Index]);
    SeqReg : Write(SeqRegNames[Index]);
    GcrReg : Write(GcrRegNames[Index]);
    CgaReg : Write(CgaRegNames[Index]);
    MiscReg: Write('Miscellaneous');
    Cmos   : CASE CmosBlock OF
               0: Write(Cmos1RegNames[Index]);
               1: Write(Cmos2RegNames[Index]);
             END;
    AttrReg: Write(AttrRegNames[Index]);
    DosReg : Write(DosRegNames[Index]);
  END;
END;  { ShowRegName }

PROCEDURE ShowBits;
CONST
  SBX=45;
  SBY=20;
VAR
  I,Mask: Integer;
BEGIN
  Window(SBX,SBY,SBX+RegNameLen,SBY+3);
  ClrScr;
  ShowRegName;
  Writeln;
  GotoXY(15-(BitPtr*2),2);
  TextColor(LightCyan);
  Writeln(#$19);
  Writeln('7 6 5 4 3 2 1 0');
  TextColor(Yellow);
  Mask:=$80;
  FOR I:=1 TO 8 DO BEGIN
    IF (ThisReg AND Mask) = 0 THEN
      Write('0 ')
    ELSE
      Write('1 ');
    Mask:=Mask SHR 1;
  END;
  Window(1,1,80,25);
END;

PROCEDURE ShowIndex;
BEGIN
  SplitGotoXY(1);
  Write('>');
  GotoXY(1,1)
END;  { ShowIndex }

PROCEDURE ShowData;
BEGIN
  SplitGotoXY(6);
  Write(ThisReg:3,' ');
  WriteHex(ThisReg,2);
  GotoXY(1,1);
END;  { ShowData }

PROCEDURE SetThisReg;
VAR
  B: Byte;
  DoResetSeq:Boolean;
BEGIN
  IF RegClass = MiscReg THEN BEGIN
    Port[Base]:=ThisReg;
    IF NOT EgaVga THEN
      Cga_Mode:=ThisReg;
  END ELSE BEGIN
    DoResetSeq:=((RegClass = SeqReg) AND (Index = MaxSeqReg));
    IF DoResetSeq THEN BEGIN
      Port[Base]:=0;
      Port[Base+1]:=$01;
    END;
    IF RegClass = AttrReg THEN BEGIN
      B := Port[$3DA];
      Port[Base]:=Index-1;
      Port[Base]:=ThisReg;
      B := Port[$3DA];
      Port[Base] := $20;
    END ELSE IF RegClass = Cmos THEN
      Port[Base]:=Index+(MaxCmosReg*CmosBlock)-1
    ELSE
      Port[Base]:=Index-1;
    Port[Base+1]:=ThisReg;
    IF DoResetSeq THEN BEGIN
      Port[Base]:=0;
      Port[Base+1]:=$03;
    END;
  END;
END;  { SetThisReg }

PROCEDURE SetAllRegs;

  PROCEDURE SetTheseRegs(ThisRegClass:RegType;
                         ThisRegOfs,ThisBase,Start,Count: Integer);
  BEGIN
    Base := ThisBase;
    RegOfs := ThisRegOfs;
    RegClass := ThisRegClass;
    FOR Index := Start TO Count DO BEGIN
      ThisReg := ParamRegs[Index-1+RegOfs];
      SetThisReg;
    END;
  END;

BEGIN
  Port[$3D4] := $11;
  Port[$3D5] := Port[$3D5] AND $7F;
  SetTheseRegs(MiscReg,MiscOfs,$3D8,1,1);
  SetTheseRegs(CrtReg,CrtOfs,$3D4,1,MaxCrtReg);
  SetTheseRegs(GcrReg,GcrOfs,$3CE,1,MaxGcrReg);
  SetTheseRegs(SeqReg,SeqOfs,$3C4,2,MaxSeqReg);
  SetTheseRegs(AttrReg,AttrOfs,$3C0,1,MaxAttrReg);
END;  { SetAllRegs }

PROCEDURE UpdateData;
BEGIN
  ParamRegs[Index-1+RegOfs]:=ThisReg;
  SetThisReg;
  ShowData;
  ShowBits;
END;  { UpdateData }

PROCEDURE SetBit(State: Boolean);
CONST
  Masks : ARRAY[0..7] OF Integer = ($01,$02,$04,$08,$10,$20,$40,$80);
BEGIN
  IF State THEN
    ThisReg:=ThisReg OR Masks[BitPtr]
  ELSE
    ThisReg:=ThisReg AND NOT Masks[BitPtr];
  UpdateData;
END;  { SetBit }

PROCEDURE ShowLock;
BEGIN
  IF Adaptor = VGA THEN BEGIN
    GotoXY(6,21);
    TextColor(LightCyan);
    Write('11H ');
    IF (ParamRegs[CrtOfs+$11] AND $80) <> 0 THEN
      TextColor(LightRed)
    ELSE BEGIN
      TextColor(LightGreen);
      Write('UN');
    END;
    Write('LOCKED  ');
    TextColor(Yellow);
    GotoXY(1,1);
  END;
END;  { ShowLock }

PROCEDURE ShowRegisters;
VAR
  I,H,Start,Limit: Integer;
BEGIN
  ClrScr;
  IF RegClass <> Cmos THEN
    ShowAdaptorName;
  CASE RegClass OF
    CgaReg,
    CrtReg : Write(' CRT Registers : ');
    SeqReg : IF TridentVga THEN
               Write(' Sequencer Registers/Trident Registers : ')
             ELSE
               Write(' Sequencer Registers : ');
    GcrReg : IF ParadiseVga THEN
               Write(' Graphics Controller/Paradise Registers : ')
             ELSE
               Write(' Graphics Controller Registers : ');
    MiscReg: Write(' Miscellaneous Register : ');
    Cmos   : Write('CMOS Registers #',CmosBlock+1,' : ');
    AttrReg: Write(' Attribute Registers : ');
    DosReg : Write(' Dos Variables : ');
  END;
  WriteHex(Base,3);
  GotoXY(1,25);
  TextColor(LightCyan);
  Write('Commands  -  Register: ');
  TextColor(Yellow);
  Write('Home ',#$18,' ',#$19,' End');
  TextColor(LightRed);
  Write(' + - ');
  TextColor(LightCyan);
  Write('    Bit : ');
  TextColor(Yellow);
  Write(#$1A,' ',#$1B);
  TextColor(LightRed);
  Write(' 0 1');
  TextColor(LightCyan);
  Write('    Reset : ');
  TextColor(LightRed);
  Write('R');
  TextColor(Yellow);
  IF RegClass = SeqReg THEN
    Start:=2
  ELSE
    Start:=1;
  IF Count < MaxLine THEN
    Limit:=Count
  ELSE
    Limit:=MaxLine;
  FOR Index:=Start TO Count DO BEGIN
    GotoXY(1,1);
    GetThisReg;
    SplitGotoXY(2);
    TextColor(LightCyan);
    IF RegClass=Cmos THEN
      WriteHex(Index+(MaxCmosReg*CmosBlock)-1,2)
    ELSE
      WriteHex(Index-1,2);
    TextColor(Yellow);
    ShowData;
    SplitGotoXY(15);
    ShowRegName;
  END;
  Index:=Start;
  BitPtr:=0;
  ShowIndex;
  GetThisReg;
  ShowBits;
END;  { ShowRegisters }

PROCEDURE EditRegisters;
VAR
  H: Integer;
BEGIN
  CASE KeyFunc OF
    CLeft : BEGIN
              INC(BitPtr);
              IF BitPtr > 7 THEN
                BitPtr:=0;
              ShowBits;
            END;
    CRight: BEGIN
              DEC(BitPtr);
              IF BitPtr < 0 THEN
                BitPtr:=7;
              ShowBits
            END;
    CUp   : BEGIN
              EraseIndex;
              DEC(Index);
              IF Index < 1 THEN
                Index:=Count;
              ShowIndex;
              GetThisReg;
              ShowBits;
            END;
    CDown : BEGIN
              EraseIndex;
              INC(Index);
              IF Index > Count THEN
                Index:=1;
              ShowIndex;
              GetThisReg;
              ShowBits;
            END;
    CHome : BEGIN
              EraseIndex;
              Index:=1;
              ShowIndex;
              GetThisReg;
              ShowBits;
            END;
    CEnd  : BEGIN
              EraseIndex;
              Index:=Count;
              ShowIndex;
              GetThisReg;
              ShowBits;
            END;
    Normal : CASE UpCase(Key) OF
               '+' : BEGIN
                       GetThisReg;
                       INC(ThisReg);
                       UpdateData;
                     END;
               '-' : BEGIN
                       GetThisReg;
                       DEC(ThisReg);
                       UpdateData;
                     END;
               '0' : SetBit(False);
               '1' : SetBit(True);
               'R' : BEGIN
                       ResetAdaptor;
                       ClrScr;
                       ShowRegisters;
                     END;
             END;
  END;
END;  { EditRegisters }

PROCEDURE VgaCrt;
VAR
  I:Integer;
BEGIN
  IF Adaptor=MDA THEN
    Base:=$3B4
  ELSE
    Base:=$3D4;
  IF EgaVga THEN BEGIN
    IF TridentVga THEN
      Count:=MaxTriCrtReg
    ELSE
      Count:=MaxCrtReg;
    RegClass:=CrtReg;
  END ELSE BEGIN
    Count:=MaxCgaReg;
    RegClass:=CgaReg;
  END;
  RegOfs:=CrtOfs;
  ShowRegisters;
  REPEAT
    ShowLock;
    WaitKey(Key,KeyFunc);
    EditRegisters;
  UNTIL KeyFunc = ESC;
END;  { VgaCrt }

PROCEDURE VgaGcr;
VAR
  I:Integer;
BEGIN
  Base:=$3CE;
  IF ParadiseVga THEN
    Count:=MaxParReg
  ELSE
    Count:=MaxGcrReg;
  RegClass:=GcrReg;
  RegOfs:=GcrOfs;
  ShowRegisters;
  REPEAT
    WaitKey(Key,KeyFunc);
    EditRegisters;
  UNTIL KeyFunc = ESC;
END;  { VgaGcr }

PROCEDURE VgaSeq;
VAR
  I:Integer;
BEGIN
  Base:=$3C4;
  IF TridentVga THEN
    Count:=MaxTriSeqReg
  ELSE
    Count:=MaxSeqReg;
  RegClass:=SeqReg;
  RegOfs:=SeqOfs;
  ShowRegisters;
  REPEAT
    WaitKey(Key,KeyFunc);
    EditRegisters;
  UNTIL KeyFunc = ESC;
END;  { VgaSeq }

PROCEDURE VgaAttr;
BEGIN
  Base:=$3C0;
  Count:=MaxAttrReg;
  RegClass:=AttrReg;
  RegOfs:=AttrOfs;
  ShowRegisters;
  REPEAT
    WaitKey(Key,KeyFunc);
    EditRegisters;
  UNTIL KeyFunc = ESC;
END;  { VgaAttr }

PROCEDURE VgaMisc;
BEGIN
  IF EgaVga THEN
    Base:=$3C2
  ELSE IF Adaptor = MDA THEN
    Base:=$3B8
  ELSE
    Base:=$3D8;
  Count:=1;
  RegClass:=MiscReg;
  RegOfs:=MiscOfs;
  ShowRegisters;
  REPEAT
    WaitKey(Key,KeyFunc);
    EditRegisters;
  UNTIL KeyFunc = ESC;
END;  { VgaMisc }

PROCEDURE CmosCheckSum(Line,F,T: Integer);
VAR
  I:Integer;
  CSum: WORD;
BEGIN
  CSum:=0;
  FOR I:=F TO T DO BEGIN
    Port[Base]:=I;
    CSum:=CSum + Port[Base+1];
  END;
  GotoXY(1,Line);
  Write('Computed Checksum for ');
  Writehex(F,2);
  Write('to ');
  WriteHex(T,2);
  Write(': ');
  WriteHex(CSum,4);
  GotoXY(1,1);
END;  { CmosCheckSum }

PROCEDURE AT_CMOS;
BEGIN
  Base:=$70;
  Count:=MaxCmosReg;
  RegClass:=Cmos;
  FOR CmosBlock:=0 TO 3 DO BEGIN
    ShowRegisters;
    CASE CmosBlock OF
      1: BEGIN
           CmosCheckSum(21,$10,$2D);
           CmosCheckSum(22,$34,$3D);
           CmosCheckSum(23,$40,$6F);
         END;
{      3: CmosCheckSum(21,$34,$7F);}
    END;
    REPEAT
      WaitKey(Key,KeyFunc);
      EditRegisters;
    UNTIL KeyFunc = ESC;
  END;
END;  { AT_CMOS }

PROCEDURE VgaDos;
BEGIN
  Base:=$0;
  Count:=MaxDosReg;
  RegClass:=DosReg;
  RegOfs:=DosOfs;
  ShowRegisters;
  REPEAT
    WaitKey(Key,KeyFunc);
  UNTIL KeyFunc = ESC;
END;  { VgaDos }

PROCEDURE SetFileName(VAR FileName: String);
BEGIN
  IF Length(FileName) = 0 THEN BEGIN
    GotoXY(1,24);
    Write('Parameter File Name : ');
    Readln(FileName);
  END;
  IF (Length(FileName) > 0) AND (POS('.',FileName) = 0) THEN
    FileName:=FileName + '.PAR';
END;  { SetFileName }

PROCEDURE LoadParamFile(FName: String);
VAR
  FileName: String;
  PFile: FILE OF VideoParamType;
BEGIN
  FileName:=FName;
  SetFileName(FileName);
  IF Length(FileName) > 0 THEN BEGIN
    ASSIGN(PFile,FileName);
{$I-}
    RESET(PFile);
{$I+}
    GotoXY(1,24);
    ClrEol;
    IF IOResult<>0 THEN BEGIN
      Write('Unable to open parameter file : ',FileName);
      WaitKey(Key,KeyFunc);
    END ELSE BEGIN
      READ(PFile,ParamRegs);
      CLOSE(PFile);
      IF Adaptor = VGA THEN
        SetAllRegs;
    END;
  END;
END;  { LoadParamFile }

PROCEDURE SaveParamFile(FName: String);
VAR
  FileName: String;
  PFile: FILE OF VideoParamType;
BEGIN
  FileName:=FName;
  SetFileName(FileName);
  IF Length(FileName) > 0 THEN BEGIN
    ASSIGN(PFile,FileName);
    REWRITE(PFile);
    WRITE(PFile,ParamRegs);
    CLOSE(PFile);
  END;
END;  { SaveParamFile }

PROCEDURE BiosParams;
BEGIN
  ClrScr;
  IF ForceMode > 0 THEN
    ShowParams(ForceMode,V_Save_Ptr^,True)
  ELSE IF Adaptor=VGA THEN
    ShowParams(24,V_Save_Ptr^,True)
  ELSE
    ShowParams(19+Crt_Mode,V_Save_Ptr^,True);
  Writeln;
  ShowParams(0,V_Save_Ptr^,False);
  REPEAT
    WaitKey(Key,KeyFunc);
  UNTIL KeyFunc=ESC;
END;  { BiosParams }

PROCEDURE ParamValues;
VAR
  VResult: Integer;
BEGIN
  ForceMode := 0;
  ParamStr1 := ParamStr(1);
  IF ParamCount > 1 THEN
    Val(ParamStr(2),ForceMode,VResult);
  IF VResult <> 0 THEN
    ForceMode := 0;
  EgaVga := FALSE;
  CASE UpCase(ParamStr1[1]) OF
    'V' : BEGIN
            Adaptor:=VGA;
            EgaVga := TRUE;
          END;
    'E' : BEGIN
            Adaptor:=EGA;
            EgaVga := TRUE;
          END;
    'C' : Adaptor:=CGA;
    'M' : Adaptor:=MDA;
  END;
  SetParamRegs;
END;  { ParamValues }

PROCEDURE Command(VAR Done: Boolean);
BEGIN
  Done:=False;
  ClrScr;
  ShowAdaptorName;
  Writeln(' Video Set Program by B Whitnall, v1.6');
  Writeln;
  Writeln('C : Crt Registers');
  IF EgaVga THEN BEGIN
    IF ParadiseVga THEN
      Writeln('G : Graphics Controller/Paradise Registers')
    ELSE
      Writeln('G : Graphics Controller Registers');
    IF TridentVga THEN
      Writeln('S : Sequencer Controller/Trident Registers')
    ELSE
      Writeln('S : Sequencer Registers');
    EgaVga:=True;
  END;
  Writeln('M : Miscellaneous Register');
  Writeln('D : Dos Parameters');
  Writeln('R : Reload default params');
  IF Adaptor = Vga THEN
    Writeln('P : Palette Attribute Registers');
  Writeln;
  Writeln('L : Load Parameter File');
  Writeln('W : Write (Save) Parameter File');
  Writeln;
  Writeln('A : AT CMOS registers');
  IF EgaVga THEN
    Writeln('B : Bios parameters');
  Writeln('Q : Quit');
  Writeln;
  REPEAT
    WaitKey(Key,KeyFunc);
    IF KeyFunc = ESC THEN BEGIN
      KeyFunc:=Normal;
      Key:='Q';
    END;
  UNTIL KeyFunc = Normal;
  CASE UpCase(Key) OF
    'C' : VgaCrt;
    'G' : IF EgaVga THEN VgaGcr;
    'S' : IF EgaVga THEN VgaSeq;
    'M' : VgaMisc;
    'R' : ResetAdaptor;
    'L' : LoadParamFile('');
    'W' : SaveParamFile('');
    'A' : AT_CMOS;
    'B' : IF EgaVga THEN BiosParams;
    'P' : IF Adaptor=Vga THEN VgaAttr;
    'D' : VgaDos;
    'Q' : Done:=True;
  END;
END;  { Command }

BEGIN
  IF ParamCount = 0 THEN
    SetAdaptor
  ELSE
    ParamValues;
  IF Adaptor = VGA THEN
    SetVgaParams;
  VgaCrt;
  REPEAT
    Command(Done);
  UNTIL Done;
  TextColor(LightGray);
  TextBackground(Black);
  ClrScr;
END.
